/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class AbstractSliderButton
extends AbstractWidget {
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace("widget/slider");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("widget/slider_highlighted");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace("widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("widget/slider_handle_highlighted");
    protected static final int TEXT_MARGIN = 2;
    private static final int HANDLE_WIDTH = 8;
    private static final int HANDLE_HALF_WIDTH = 4;
    protected double value;
    private boolean canChangeValue;

    public AbstractSliderButton(int p_93579_, int p_93580_, int p_93581_, int p_93582_, Component p_93583_, double p_93584_) {
        super(p_93579_, p_93580_, p_93581_, p_93582_, p_93583_);
        this.value = p_93584_;
    }

    private ResourceLocation getSprite() {
        if (this.isFocused() && !this.canChangeValue) {
            return HIGHLIGHTED_SPRITE;
        }
        return SLIDER_SPRITE;
    }

    private ResourceLocation getHandleSprite() {
        if (this.isHovered || this.canChangeValue) {
            return SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
        }
        return SLIDER_HANDLE_SPRITE;
    }

    @Override
    protected MutableComponent createNarrationMessage() {
        return Component.translatable("gui.narrate.slider", this.getMessage());
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput p_168798_) {
        p_168798_.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                p_168798_.add(NarratedElementType.USAGE, (Component)Component.translatable("narration.slider.usage.focused"));
            } else {
                p_168798_.add(NarratedElementType.USAGE, (Component)Component.translatable("narration.slider.usage.hovered"));
            }
        }
    }

    @Override
    public void renderWidget(GuiGraphics p_283427_, int p_281447_, int p_282852_, float p_282409_) {
        Minecraft $$4 = Minecraft.getInstance();
        p_283427_.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        p_283427_.blitSprite(this.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        p_283427_.blitSprite(this.getHandleSprite(), this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY(), 8, this.getHeight());
        p_283427_.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int $$5 = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderScrollingString(p_283427_, $$4.font, 2, $$5 | Mth.ceil(this.alpha * 255.0f) << 24);
    }

    @Override
    public void onClick(double p_93588_, double p_93589_) {
        this.setValueFromMouse(p_93588_);
    }

    @Override
    public void setFocused(boolean p_265705_) {
        super.setFocused(p_265705_);
        if (!p_265705_) {
            this.canChangeValue = false;
            return;
        }
        InputType $$1 = Minecraft.getInstance().getLastInputType();
        if ($$1 == InputType.MOUSE || $$1 == InputType.KEYBOARD_TAB) {
            this.canChangeValue = true;
        }
    }

    @Override
    public boolean keyPressed(int p_93596_, int p_93597_, int p_93598_) {
        if (CommonInputs.selected(p_93596_)) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean $$3;
            boolean bl = $$3 = p_93596_ == 263;
            if ($$3 || p_93596_ == 262) {
                float $$4 = $$3 ? -1.0f : 1.0f;
                this.setValue(this.value + (double)($$4 / (float)(this.width - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double p_93586_) {
        this.setValue((p_93586_ - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    private void setValue(double p_93612_) {
        double $$1 = this.value;
        this.value = Mth.clamp(p_93612_, 0.0, 1.0);
        if ($$1 != this.value) {
            this.applyValue();
        }
        this.updateMessage();
    }

    @Override
    protected void onDrag(double p_93591_, double p_93592_, double p_93593_, double p_93594_) {
        this.setValueFromMouse(p_93591_);
        super.onDrag(p_93591_, p_93592_, p_93593_, p_93594_);
    }

    @Override
    public void playDownSound(SoundManager p_93605_) {
    }

    @Override
    public void onRelease(double p_93609_, double p_93610_) {
        super.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    protected abstract void updateMessage();

    protected abstract void applyValue();
}

